#include <stdlib.h>
#include <string.h>

#include "szohalmaz.h"


/* Struktúra halmazhoz.
 * Belülről ez egy rendezett lista, mivel azon a leggyorsabb a halmaz
 * metszet előállítása. */
typedef struct Halmaz {
    char szo[2*SZOHOSSZ+1];
    struct Halmaz *kov;
} Halmaz;


/* A megadott halmazba betesz egy új számot.
 * Ha már benne van, nem csinál semmit.
 * Amúgy megegyezik az előadáson bemutatott rendezett beszúrással. */
void halmaz_betesz(Halmaz **phalmaz, char *szo)
{
    Halmaz *lemarado, *mozgo, *uj;

    /* elem keresése */
    lemarado=NULL;
    for (mozgo=*phalmaz; mozgo!=NULL && strcmp(mozgo->szo, szo) < 0; mozgo=mozgo->kov)
        lemarado=mozgo;
    /* már benne van? akkor nincs teendő */
    if (mozgo!=NULL && strcmp(mozgo->szo, szo)==0)
        return;

    uj=(Halmaz*) malloc(sizeof(Halmaz));
    strcpy(uj->szo, szo);
    if (lemarado==NULL) { /* üres vagy első elé szúrunk be? */
        uj->kov=*phalmaz;
        *phalmaz=uj;
    } else {              /* lista belsejébe/végére szúrunk be */
        lemarado->kov=uj;
        uj->kov=mozgo;
    }
}


/* Visszatér a két paraméterként adott halmaz metszetének méretével.
 * A részletes magyarázata a programozói dokumentációban. */
int halmaz_metszet_meret(Halmaz *h1, Halmaz *h2)
{
    int db=0;

    /* ha bármelyik null, nincs több összehasonlítandó */
    while (h1!=NULL && h2!=NULL) {
        int er = strcmp(h1->szo, h2->szo);

        if (er < 0)      /* h1 kisebb - az a pointer lép */
            h1=h1->kov;
        else if (er > 0) /* h2 kisebb - akkor az */
            h2=h2->kov;
        else {           /* ha az elején egyformák, akkor +1 db, és mindkét ptr lép */
            db++;
            h1=h1->kov;
            h2=h2->kov;
        }
    }
    return db;
}


/* Visszatér egy szóhalmaz elemszámával. */
int halmaz_meret(Halmaz *h)
{
    int db=0;

    while (h!=NULL) {
        db++;
        h=h->kov;
    }
    return db;
}


/* Felszabadít egy szóhalmazt. */
void halmaz_felszabadit(Halmaz *h)
{
    while (h!=NULL) {
        Halmaz *temp = h->kov;
        free(h);
        h = temp;
    }
}
