#include <stdlib.h>
#include <string.h>

#include "dolgozat.h"


/* Új dolgozatot hoz létre, a paraméterkent kapott
 * fájlnévvel és névvel.
 * A benne lévő szóhalmazokat egyelőre üresre állítja. */
Dolgozat *uj_dolgozat(char *fajlnev, char *nev)
{
    Dolgozat *uj;
    
    uj=(Dolgozat*) malloc(sizeof(Dolgozat));
    strcpy(uj->fajlnev, fajlnev);
    strcpy(uj->nev, nev);
    uj->kifejezesek=NULL;
    uj->kov=NULL;
    
    return uj;
}


/* Felszabadít egy dolgozat listát. */
void dolgozatok_felszabadit(Dolgozat *dolgozatok)
{
	while (dolgozatok!=NULL) {
		Dolgozat *temp=dolgozatok->kov;
		
        halmaz_felszabadit(dolgozatok->kifejezesek);
		free(dolgozatok);
		dolgozatok=temp;
	}
}


/* Visszaadja egy dolgozatlista hosszát. */
int dolgozatok_meret(Dolgozat* dolgozatok)
{
	int db=0;
	
	while (dolgozatok!=NULL) {
		db++;
		dolgozatok=dolgozatok->kov;
	}
	return db;
}
