#ifndef WIDGET_H
#define WIDGET_H

#include <SDL.h>


extern SDL_Surface *screen;


/* egy widget, az altalanos es a specialis adatokkal */
typedef struct Widget Widget;
struct Widget {
    int x, y, szeles, magas;    /* pozicio es meret */

    /* kirajzolashoz hasznalt fv */
    void (*rajzolo_fv) (Widget *widget);
    void (*kattintas_fv) (Widget *widget, int x, int y);
    /* kattintaskor ez hivodik, ha nem NULL */
    void (*felhasznaloi_cb) (Widget *widget, int x, int y, void *param);
    void *felhasznaloi_cb_param;        /* ezt a parametert megkapja a param valtozoban */

    enum WidgetTipus {          /* ilyen tipusu lehet */
        altalanos, gomb, csuszka, felirat, villanogomb, szovegdoboz
    } tipus;
    union {
        struct GombAdat {
            char felirat[20];   /* a gomb szovege */
        } gomb;
        struct CsuszkaAdat {
            double *valtoztatott;
        } csuszka;
        struct FeliratAdat {
            char szoveg[20];
        } felirat;
        struct VillanoGombAdat {
            int allapot;
            int villan;
        } villanogomb;
        struct SzovegDobozAdat {
            char *szoveg;       /* nem o tarolja! */
        } szovegdoboz;
    } adat;
};


void widget_init(char *ablaknev, int w, int h);
void kilep_gomb_cb(Widget *widget, int x, int y, void *param);
void widget_alap_rajzol(Widget *widget);

Widget *uj_widget(int x, int y, int szeles, int magas);
Widget *uj_gomb(int x, int y, int szeles, int magas, char const *felirat);
Widget *uj_felirat(int x, int y, char const *szoveg);
Widget *uj_csuszka(int x, int y, int szeles, int magas, double *valtoztatott);
Widget *uj_villanogomb(int x, int y, int szeles, int magas, int kezdeti);
Widget *uj_szovegdoboz(int x, int y, int szeles, int magas, char *szoveg);

void widget_ujrarajzol(Widget *w);

void callback_regisztral(SDL_EventType eventtype, void (*callback_fv) (SDL_Event *, void *),
                         void *callback_fv_param);
void esemenyvezerelt_main(Widget *widgetek[]);

int input_text(char *dest, int x, int y, int sz, int m);
void minden_widget_ujrarajzol(void);

#endif
