#include <SDL.h>
#include <SDL_gfxPrimitives.h>
#include "widget.h"


/* itt lehet állítgatni a színeket */
static unsigned long const hatter = 0x303030FF;
static unsigned long const keret = 0x000000FF;
static unsigned long const alapszin = 0x101010FF;
static unsigned long const keretvilagos = 0xFFFFFF20;
static unsigned long const gombfeliratszin = 0x00C0F0FF;
static unsigned long const csuszkaszin = 0x00FFFF50;
static unsigned long const feliratszin = 0x00C0F0FF;


enum { MINDENT_UJRARAJZOL = SDL_USEREVENT + 1 };


/* mindenki hasznalja */
SDL_Surface *screen;


/* belso hasznalatra. ide irodnak be a felhasznaloi callbackek */
typedef struct FelhasznaloiCallback {
    SDL_EventType eventtype;
    void (*callback_fv) (SDL_Event *, void *);
    void *callback_fv_param;
} FelhasznaloiCallback;
static FelhasznaloiCallback felhasznaloi_callback[20];


/* egy widget kirajzolasa, altalanossagban. egy keretet ad csak. */
/* a keret tulnyulik az aktiv (kattinthato) mereten. */
void widget_alap_rajzol(Widget *widget) {
    int y;
    roundedRectangleColor(screen, widget->x - 1, widget->y - 1, widget->x + widget->szeles,
                          widget->y + widget->magas, 2, keret);
    boxColor(screen, widget->x, widget->y, widget->x + widget->szeles - 1,
             widget->y + widget->magas - 1, alapszin);
    for (y = 0; y < 20; ++y) {
        boxRGBA(screen, widget->x, widget->y + y * widget->magas / 20,
                widget->x + widget->szeles - 1, widget->y + (y + 1) * widget->magas / 20 - 1, 255,
                255, 255, (19 - y) * 3);
    }
    rectangleColor(screen, widget->x, widget->y, widget->x + widget->szeles - 1,
                   widget->y + widget->magas - 1, keretvilagos);
}


/* letrehoz egy uj, egyelore ismeretlen tipusu widgetet. tulajdonkepp csak a helyet allitja be */
Widget *uj_widget(int x, int y, int szeles, int magas) {
    Widget *uj = (Widget *) malloc(sizeof(Widget));
    uj->tipus = altalanos;
    uj->x = x;
    uj->y = y;
    uj->szeles = szeles;
    uj->magas = magas;
    uj->rajzolo_fv = widget_alap_rajzol;
    uj->kattintas_fv = NULL;
    uj->felhasznaloi_cb = NULL;
    uj->felhasznaloi_cb_param = NULL;
    return uj;
}


/* kirajzolja a gombot. keret, alapszin, felirat. */
static void gomb_rajzol(Widget *gomb) {
    widget_alap_rajzol(gomb);
    stringColor(screen, gomb->x + (gomb->szeles - strlen(gomb->adat.gomb.felirat) * 8) / 2,
                gomb->y + (gomb->magas - 8) / 2, gomb->adat.gomb.felirat, gombfeliratszin);
}


/* gombot hoz letre. */
Widget *uj_gomb(int x, int y, int szeles, int magas, char const *felirat) {
    Widget *uj = uj_widget(x, y, szeles, magas);
    uj->tipus = gomb;
    uj->rajzolo_fv = gomb_rajzol;
    strcpy(uj->adat.gomb.felirat, felirat);
    return uj;
}


/* kirajzol egy feliratot. nem hivodik az alap rajzolo, mert nem kell neki keret! */
static void felirat_rajzol(Widget *felirat) {
    stringColor(screen, felirat->x, felirat->y, felirat->adat.felirat.szoveg, feliratszin);
}


/* feliratot hoz letre. */
Widget *uj_felirat(int x, int y, char const *szoveg) {
    Widget *uj = uj_widget(x, y, 0, 0);
    uj->tipus = felirat;
    uj->rajzolo_fv = felirat_rajzol;
    strcpy(uj->adat.felirat.szoveg, szoveg);
    return uj;
}


/* csuszkaot rajzol; a keretet meghagyja, de belul mindent
 * felulir a sajat szinevel */
static void csuszka_rajzol(Widget *csuszka) {
    widget_alap_rajzol(csuszka);
    boxColor(screen, csuszka->x, csuszka->y,
             csuszka->x + csuszka->szeles * (*csuszka->adat.csuszka.valtoztatott),
             csuszka->y + csuszka->magas - 1, csuszkaszin);
}


/* ez a sajat adatfeldolgozoja; nem kulon hozzaadott, hanem elvalaszthatatlan */
static void csuszka_kattintas(Widget *csuszka, int x, int y) {
    *csuszka->adat.csuszka.valtoztatott = (double) x / (csuszka->szeles);
    csuszka_rajzol(csuszka);
}


/* csuszkat hoz letre */
Widget *uj_csuszka(int x, int y, int szeles, int magas, double *valtoztatott) {
    Widget *uj = uj_widget(x, y, szeles, magas);
    uj->tipus = csuszka;
    uj->rajzolo_fv = csuszka_rajzol;
    uj->kattintas_fv = csuszka_kattintas;
    uj->adat.csuszka.valtoztatott = valtoztatott;
    return uj;
}


/* a villano gomb kirajzolasa - ha aktiv, vilagit */
static void villanogomb_rajzol(Widget *gomb) {
    widget_alap_rajzol(gomb);
    if (gomb->adat.villanogomb.allapot) {
        boxColor(screen, gomb->x, gomb->y, gomb->x + gomb->szeles - 1, gomb->y + gomb->magas - 1,
                 csuszkaszin);
        if (gomb->adat.villanogomb.villan)
            boxColor(screen, gomb->x, gomb->y, gomb->x + gomb->szeles - 1,
                     gomb->y + gomb->magas - 1, 0xFFFFFFC0);
    } else {
        if (gomb->adat.villanogomb.villan)
            boxColor(screen, gomb->x, gomb->y, gomb->x + gomb->szeles - 1,
                     gomb->y + gomb->magas - 1, 0xFFFFFF10);
    }
}


/* ha kattintanak ra, invertalodik az allapota */
static void villanogomb_kattintas(Widget *gomb, int x, int y) {
    gomb->adat.villanogomb.allapot = !gomb->adat.villanogomb.allapot;
    villanogomb_rajzol(gomb);
}


/* csuszkat hoz letre */
Widget *uj_villanogomb(int x, int y, int szeles, int magas, int kezdeti) {
    Widget *uj = uj_widget(x, y, szeles, magas);
    uj->tipus = villanogomb;
    uj->rajzolo_fv = villanogomb_rajzol;
    uj->kattintas_fv = villanogomb_kattintas;
    uj->adat.villanogomb.allapot = kezdeti;
    uj->adat.villanogomb.villan = 0;
    return uj;
}


/* szovegdoboz rajzolasA: normal alap, es ra a szoveg. semmi kulonos. */
static void szovegdoboz_rajzol(Widget *w) {
    widget_alap_rajzol(w);
    stringColor(screen, w->x + 4, w->y + (w->magas - 8) / 2, w->adat.szovegdoboz.szoveg,
                feliratszin);
}


/* letrehoz egy uj szovegdobozt. */
Widget *uj_szovegdoboz(int x, int y, int szeles, int magas, char *szoveg) {
    Widget *w = uj_widget(x, y, szeles, magas);
    w->tipus = szovegdoboz;
    w->rajzolo_fv = szovegdoboz_rajzol;
    w->adat.szovegdoboz.szoveg = szoveg;
    return w;
}


/* csak annyit csinal, hogy kirajzolja ujra */
void widget_ujrarajzol(Widget *w) {
    w->rajzolo_fv(w);
    SDL_UpdateRect(screen, w->x - 1, w->y - 1, w->szeles + 2, w->magas + 2);
}


/* olyan esemenyt tesz be a sorba, amelynek hatasara minden widget ujra lesz rajzolva */
void minden_widget_ujrarajzol(void) {
    SDL_Event ev = { MINDENT_UJRARAJZOL };
    SDL_PushEvent(&ev);
}


/* ez nullarol megrajzol mindent. */
static void egesz_kepernyo_ujrarajzol(Widget *widgetek[]) {
    int i, x, y;
    
    boxColor(screen, 0, 0, screen->w - 1, screen->h - 1, hatter);
    for (y = 0; y < screen->h; ++y)
        for (x = 0; x < screen->w; ++x)
            pixelRGBA(screen, x, y, 255, 255, 255, rand() % 12);
    for (i = 0; widgetek[i] != NULL; i++)
        widgetek[i]->rajzolo_fv(widgetek[i]);
    SDL_Flip(screen);
}

/* az esemenyhurok kirajzolja a widgeteket, es feldolgozza a felhasznalotol erkezo
 * esemenyeket (eger kattintasok es ablak bezarasa.) */
void esemenyvezerelt_main(Widget *widgetek[]) {
    int vege;

    /* azzal kezdjuk, hogy mindent kirajzolunk */
    egesz_kepernyo_ujrarajzol(widgetek);

    /* esemenyhurok */
    vege = 0;
    while (!vege) {
        SDL_Event ev;
        int i;

        SDL_WaitEvent(&ev);

        /* nezzuk a beepitett dolgainkat */
        switch (ev.type) {
        case SDL_QUIT:
            vege = 1;
            break;

        case MINDENT_UJRARAJZOL:
            egesz_kepernyo_ujrarajzol(widgetek);
            break;

        case SDL_MOUSEBUTTONDOWN:
            for (i = 0; widgetek[i] != NULL; i++) {
                /* ennek a widgetnek a teruletere kattintott? */
                if (ev.button.x >= widgetek[i]->x && ev.button.y >= widgetek[i]->y
                    && ev.button.x < widgetek[i]->x + widgetek[i]->szeles
                    && ev.button.y < widgetek[i]->y + widgetek[i]->magas) {
                    /* widget-relativ kattintas koordinatak */
                    int bx = ev.button.x - widgetek[i]->x;
                    int by = ev.button.y - widgetek[i]->y;
                    /* widgetek belso mukodese */
                    if (widgetek[i]->kattintas_fv != NULL)
                        widgetek[i]->kattintas_fv(widgetek[i], bx, bx);
                    /* esetleg tarsitott callback */
                    if (widgetek[i]->felhasznaloi_cb != NULL)
                        widgetek[i]->felhasznaloi_cb(widgetek[i], bx, by,
                                                     widgetek[i]->felhasznaloi_cb_param);
                }
            }
            SDL_Flip(screen);   /* tortenhettek valtozasok, rajzolas */
            break;
        }
        /* nezzuk a felhasznalo dolgait */
        for (i = 0; i < 20; ++i)
            if (felhasznaloi_callback[i].callback_fv != NULL
                && felhasznaloi_callback[i].eventtype == ev.type)
                felhasznaloi_callback[i].callback_fv(&ev,
                                                     felhasznaloi_callback[i].callback_fv_param);
    }
}


/* a gomb rakattintva general egy szintetikus SDL_QUIT esemenyt.
 * barmely alkalmazas hasznalhatja kilepes gombnak */
void kilep_gomb_cb(Widget *widget, int x, int y, void *param) {
    SDL_Event ev = { SDL_QUIT };
    SDL_PushEvent(&ev);
}


/* inicializalja a widgetes dolgokat */
void widget_init(char *ablaknev, int w, int h) {
    int i;

    screen = SDL_SetVideoMode(w, h, 0, SDL_ANYFORMAT);
    if (!screen) {
        fprintf(stderr, "Nem sikerult megnyitni az ablakot!\n");
        exit(1);
    }
    SDL_WM_SetCaption(ablaknev, ablaknev);
    for (i = 0; i < 20; ++i)
        felhasznaloi_callback[i].callback_fv = NULL;
    SDL_EnableUNICODE(1);
}


/* az adott tipusu esemenyhez folvesz egy felhasznaloi callbacket, ami meg lesz hivva
 * a megadott parameterrel az esemenyvezerelt mainbol, ha ilyen tortenik. */
void callback_regisztral(SDL_EventType eventtype, void (*callback_fv) (SDL_Event *, void *),
                         void *callback_fv_param) {
    int i;

    for (i = 0; i < 20 && felhasznaloi_callback[i].callback_fv != NULL; ++i);   /* megkeresi az elso ureset */
    if (i == 20)
        abort();                /* nincs hely */
    /* beteszi a tombbe */
    felhasznaloi_callback[i].eventtype = eventtype;
    felhasznaloi_callback[i].callback_fv = callback_fv;
    felhasznaloi_callback[i].callback_fv_param = callback_fv_param;
}


/* text input boxot rajzol ki, amibe a juzer beirhat egy szoveget.
 * kell adni neki a destben egy puffert, amiben dolgozhat, es ott lesz
 * az eredmeny is. igazzal ter vissza, ha a szoveg beolvasva.
 * ugyanolyan koordinatakat kell adni, mint barmelyik widgetnek.
 * kitakaritja maga utan a kepernyot. */
int input_text(char *dest, int x, int y, int sz, int m) {
    SDL_Event event;
    int hossz, kilep, enter;
    Widget *w;

    hossz = 0;
    dest[hossz] = '\0';
    w = uj_szovegdoboz(x, y, sz, m, dest);
    widget_ujrarajzol(w);
    enter = 0;
    kilep = 0;
    while (!kilep && !enter) {
        SDL_WaitEvent(&event);
        switch (event.type) {
        case SDL_KEYDOWN:
            switch (event.key.keysym.unicode) {
            case '\0':
                /* nincs neki megfelelo karakter (pl. shift gomb) */
                break;
            case '\r':
            case '\n':
                /* enter: bevitel vege */
                enter = 1;
                break;
            case '\b':
                /* backspace: torles visszafele, ha van karakter */
                if (hossz > 0) {
                    dest[--hossz] = '\0';
                    widget_ujrarajzol(w);       /* valtozott */
                }
                break;
            default:
                if (event.key.keysym.unicode < 0x80) {  /* ascii? */
                    /* karakter: tombbe vele, plusz lezaro nulla */
                    dest[hossz++] = event.key.keysym.unicode;
                    dest[hossz] = '\0';
                    widget_ujrarajzol(w);       /* valtozott */
                }
                break;
            }
            break;
        case SDL_QUIT:
            /* visszatesszuk a sorba ezt az eventet, mert
             * sok mindent nem tudunk vele kezdeni */
            SDL_PushEvent(&event);
            kilep = 1;
            break;
        }
    }
    free(w);

    minden_widget_ujrarajzol();

    /* 1 jelzi a helyes beolvasast; = ha enter miatt allt meg a ciklus */
    return enter;
}
