#ifndef SYNTH_H
#define SYNTH_H


typedef enum HangAllapot {
    csend, felfutas, elengedes
} HangAllapot;


typedef struct Hang {
    char *nev;
    double frek;                /* a frekvenciaja */
    double hangero;             /* a hangero, 0->1 és 1->0 valtoztatva, hogy ne pattogjon */
    int indit;                  /* igaz erteket ide rakva, indul a hang */
    HangAllapot all;            /* aktualis allapot a burkologorbehez */
    double hol;                 /* 0 = bal, 0.5 = kozep, 1 = jobb */
} Hang;


typedef struct HangSzin {
    double felfutas_ido;        /* masodperc */
    double elengedes_ido;       /* masodperc */
    double torz;

    struct Harmonikus {
        double frekszorzo;      /* hanyszoros frekvencia az alaphanghoz kepest */
        double arany;           /* mekkora hangerovel */
        char *nev;              /* a neve */
    } felharm[10];              /* felharmonikusok. 0-dik nem hasznalt, 1-es az alap. */
} HangSzin;


typedef struct Szinti {
    HangSzin *hangszin;
    Hang *hangok;
    double amplmod_frek, amplmod_ampl;
    double hangero;
} Szinti;


void hang_init(Szinti *szinti);
void hang_start(void);
void hang_stop(void);
void hang_bezar();

#endif
