#include <SDL.h>
#include <SDL_keysym.h>
#include <math.h>

#include "synth.h"

#define PI 3.14159265

/* nehany globalis valtozo a hangok adataihoz */
static SDL_AudioSpec audiospec;
static double t = 0;            /* az eltelt ido */
static double *visszhang;
static int visszhangmeret = 0;
static int visszhanghol = 0;

/* ez hivodik meg, amikor az SDL ujabb adag hangot ker tolunk */
void hang_callback(void *userdata, Uint8 * stream8, int len) {
    Szinti *sz = (Szinti *) userdata;
    Sint16 *stream = (Sint16 *) stream8;        /* a puffer, amit kaptunk: signed integer, 16 bit */
    double dt = 1.0 / audiospec.freq;   /* ennyi masodperc hangmintankent */
    int mintak;
    int x, i;
    HangSzin *hsz = sz->hangszin;
    double (*torz)(double) = tanh;      /* atan is jo, kicsi mas a hangja */
    double torz_szorzo = 1 / (1-hsz->torz+0.01);
    double torz_max = torz(torz_szorzo);

    mintak = len / sizeof(stream[0]) / 2;       /* mert bajtban szamol, nekunk meg mintak szama kell, es mert sztereo */

    /* vegigmegyunk ezen az idoszeleten */
    for (x = 0; x < mintak; x++) {
        double sb = 0, sj = 0;           /* az aktualis mintak (bal, jobb) */

        /* es osszegzunk (osszemixelunk) minden hangot */
        for (i = 0; sz->hangok[i].frek != 0; ++i) {
            Hang *h = &sz->hangok[i];

            /* felharmonikusok osszegzese */
            double s_ez = 0;
            if (h->all != csend) {
                int felh;
                for (felh = 0; hsz->felharm[felh].frekszorzo != 0; ++felh)
                    if (hsz->felharm[felh].arany != 0)
                        s_ez +=
                            hsz->felharm[felh].arany * sin(hsz->felharm[felh].frekszorzo * h->frek *
                                                           2 * PI * t);
            }
            /* torzitas */
            s_ez = torz(s_ez * torz_szorzo)/torz_max;

            /* itt kezeli a burkologorbet - ez az allapotgep */
            if (h->indit) {
                h->all = felfutas;
                h->indit = 0;
                h->hol = rand()/(double)RAND_MAX * 0.6 + 0.2;
            }
            switch (h->all) {
                case csend:
                    break;
                case felfutas:
                    h->hangero += 1.0 / (hsz->felfutas_ido + 0.01) * dt;
                    if (h->hangero > 1)
                        h->all = elengedes;
                    break;
                case elengedes:
                    h->hangero -= 1.0 / (hsz->elengedes_ido + 0.01) * dt;
                    if (h->hangero < 0) {
                        h->hangero = 0;
                        h->all = csend;
                    }
                    break;
            }
            /* burkologorbe */
            s_ez *= h->hangero;

            /* bal es jobbra szetvalasztas */
            sb += h->hol * s_ez;
            sj += (1-h->hol) * s_ez;
        }
        /* itt tortenik az amplitudo modulacioja */
        sb *= (1 + sz->amplmod_ampl * sin(sz->amplmod_frek * 25 * 2 * PI * t));
        sj *= (1 + sz->amplmod_ampl * sin(sz->amplmod_frek * 25 * 2 * PI * t));

        /* visszhang hozzaadasa */
        sb = sb + visszhang[2*visszhanghol] * 0.1;
        sj = sj + visszhang[2*visszhanghol+1] * 0.1;
        visszhang[2 * visszhanghol] = sj;   /* forditva! */
        visszhang[2 * visszhanghol+1] = sb;

        /* itt bekerul a pufferbe az osszemixelt minta, a master hangerovel */
        stream[2*x] = sb * sz->hangero;
        stream[2*x+1] = sj * sz->hangero;

        t += dt;                /* eltelt ennyi ido */
        visszhanghol = (visszhanghol+1) % (int)visszhangmeret;
    }
}


/* SDL hanglejatszas inditasa */
void hang_init(Szinti *szinti) {
    audiospec.freq = 44100;                /* 44100Hz - CD minoseg, 48000 - dvd minoseg */
    audiospec.format = AUDIO_S16SYS;       /* 16-bit elojeles; a rendszer bajtsorrendjevel */
    audiospec.channels = 2;                /* mono */
    audiospec.samples = audiospec.freq/50; /* puffer merete - 1/50 sec */
    audiospec.callback = hang_callback;    /* sdl hivja, ha ujabb adag hang kell neki */
    audiospec.userdata = (void *) szinti;  /* egy pointert atad mindig a callbacknek */
    if (SDL_OpenAudio(&audiospec, NULL) < 0) {
        fprintf(stderr, "Hiba a hanggal: %s\n", SDL_GetError());
        exit(1);
    }
    visszhangmeret = audiospec.freq / 3;
    visszhang = (double *) malloc(sizeof(double) * visszhangmeret * 2);
    memset(visszhang, 0, visszhangmeret * 2 * sizeof(double));
}


void hang_bezar(Szinti *szinti) {
    SDL_CloseAudio();
}


/* hang inditasa */
void hang_start(void) {
    SDL_PauseAudio(0);
}


/* hang leallitasa */
void hang_stop(void) {
    SDL_PauseAudio(1);
}
