#include <SDL.h>
#include <SDL_gfxPrimitives.h>

#include "widget.h"
#include "synth.h"


typedef struct ZeneGep {
    Szinti *sz;                 /* a lejatszashoz hasznalt szinti */
    double tempo;               /* a lejatszas sebessege ebbol szamolodik */
    int fazis;                  /* hanyadik utemben tart */
    Widget *gomb[16][16];       /* gomb[fazis][magassag] */
} ZeneGep;


/* kitorli az osszes hangot */
void ures_matrix(Widget *widget, int xclk, int yclk, void *param) {
    ZeneGep *zg = (ZeneGep *) param;
    int x, y;

    for (x = 0; x < 16; ++x)
        for (y = 0; y < 16; ++y) {
            zg->gomb[x][y]->adat.villanogomb.allapot = 0;
            widget_ujrarajzol(zg->gomb[x][y]);
        }
}


/* a mentes gomb fuggvenye. kerdez egy fajlnevet, es ha kapott, akkor elmenti
 * az adatokat. */
void mentes(Widget *widget, int xclk, int yclk, void *param) {
    ZeneGep *zg = (ZeneGep *) param;
    char fajlnev[100];

    if (input_text(fajlnev, 30, 400, 640, 20)) {
        int i, x, y;
        FILE *fp;

        fp = fopen(fajlnev, "wt");
        if (!fp)
            return;

        fprintf(fp, "InfoC_Zenegep_V1\n");
        fprintf(fp, "%g\n", zg->tempo);
        fprintf(fp, "%g %g\n", zg->sz->hangszin->felfutas_ido, zg->sz->hangszin->elengedes_ido);
        fprintf(fp, "%g %g\n", zg->sz->amplmod_frek, zg->sz->amplmod_ampl);
        fprintf(fp, "%g\n", zg->sz->hangszin->torz);
        for (i = 0; zg->sz->hangszin->felharm[i].frekszorzo != 0; ++i)
            fprintf(fp, "%g\n", zg->sz->hangszin->felharm[i].arany);
        for (y = 0; y < 16; ++y) {
            for (x = 0; x < 16; ++x)
                fprintf(fp, "%d ", zg->gomb[x][y]->adat.villanogomb.allapot);
            fprintf(fp, "\n");
        }
        fclose(fp);
    }
}


/* a betoltes gomb callbackje. kerdez egy fajlnevet, es ha kapott,
 * akkor abbol visszatolti a zenet. */
void betoltes(Widget *widget, int xclk, int yclk, void *param) {
    ZeneGep *zg = (ZeneGep *) param;
    char fajlnev[100];

    if (input_text(fajlnev, 30, 400, 640, 20)) {
        char s[100];
        int i, x, y;
        FILE *fp;

        fp = fopen(fajlnev, "rt");
        if (!fp)
            return;

        fscanf(fp, "%100s", s);
        if (strcmp(s, "InfoC_Zenegep_V1") != 0) {
            fclose(fp);
            return;
        }
        fscanf(fp, "%lg\n", &zg->tempo);
        fscanf(fp, "%lg %lg\n", &zg->sz->hangszin->felfutas_ido, &zg->sz->hangszin->elengedes_ido);
        fscanf(fp, "%lg %lg\n", &zg->sz->amplmod_frek, &zg->sz->amplmod_ampl);
        fscanf(fp, "%lg\n", &zg->sz->hangszin->torz);
        for (i = 0; zg->sz->hangszin->felharm[i].frekszorzo != 0; ++i)
            fscanf(fp, "%lg\n", &zg->sz->hangszin->felharm[i].arany);
        for (y = 0; y < 16; ++y) {
            for (x = 0; x < 16; ++x) {
                fscanf(fp, "%d ", &zg->gomb[x][y]->adat.villanogomb.allapot);
                widget_ujrarajzol(zg->gomb[x][y]);
            }
        }
        fclose(fp);
    }
    minden_widget_ujrarajzol();
}


/* az idozito altal betett esemeny tipusa a zene leptetesehez */
enum { ZENET_LEPTET = SDL_USEREVENT + 2 };


/* az idozito fuggveny (SDL_AddTimer-hez). Azert kell latnia a zenegepet,
 * mert abbol olvassa ki a varakozasok kozt eltelo idot */
Uint32 idozit(Uint32 ms, void *zgv) {
    ZeneGep *zg = (ZeneGep *) zgv;
    SDL_Event ev = { ZENET_LEPTET };
    SDL_PushEvent(&ev);
    return 600 - zg->tempo * 500;       /* ujabb varakozas (ms) */
}


/* ez a fuggveny "lepteti" a zenet, es allitja be az uj lejatszando
 * hangokat. az esemenyvezerelt mainbol fog meghivodni, az idozito
 * fuggveny altal betett zenet_leptet esemeny hatasara. */
void zene_leptet(SDL_Event * event, void *zgv) {
    ZeneGep *zg = (ZeneGep *) zgv;
    int y;

    /* elozo fazis */
    for (y = 0; y < 16; ++y) {
        zg->gomb[zg->fazis][y]->adat.villanogomb.villan = 0;
        widget_ujrarajzol(zg->gomb[zg->fazis][y]);
    }
    /* uj fazis (leptetes) es villantas */
    zg->fazis = (zg->fazis + 1) % 16;
    for (y = 0; y < 16; ++y) {
        zg->gomb[zg->fazis][y]->adat.villanogomb.villan = 1;
        widget_ujrarajzol(zg->gomb[zg->fazis][y]);
        if (zg->gomb[zg->fazis][y]->adat.villanogomb.allapot)
            zg->sz->hangok[y].indit = 1;
    }
}


int main(int argc, char *argv[]) {
    /* A szintetizator dolgai */
    Hang hangok[] = {
        {"C", 440.0 * pow(2, -9 * 1.0/12.0) * 4},
        {"A", 440.0 * pow(2,  0 * 1.0/12.0) * 2},
        {"G", 440.0 * pow(2, -2 * 1.0/12.0) * 2},
        {"F", 440.0 * pow(2, -4 * 1.0/12.0) * 2},
        {"D", 440.0 * pow(2, -7 * 1.0/12.0) * 2},
        {"C", 440.0 * pow(2, -9 * 1.0/12.0) * 2},
        {"A", 440.0 * pow(2,  0 * 1.0/12.0) * 1},
        {"G", 440.0 * pow(2, -2 * 1.0/12.0) * 1},
        {"F", 440.0 * pow(2, -4 * 1.0/12.0) * 1},
        {"D", 440.0 * pow(2, -7 * 1.0/12.0) * 1},
        {"C", 440.0 * pow(2, -9 * 1.0/12.0) * 1},
        {"A", 440.0 * pow(2,  0 * 1.0/12.0) * 0.5},
        {"G", 440.0 * pow(2, -2 * 1.0/12.0) * 0.5},
        {"F", 440.0 * pow(2, -4 * 1.0/12.0) * 0.5},
        {"D", 440.0 * pow(2, -7 * 1.0/12.0) * 0.5},
        {"C", 440.0 * pow(2, -9 * 1.0/12.0) * 0.5},
        {NULL, 0}
    };
    HangSzin hsz = {
        0.0, 0.5,              /* burkologorbe: a, r (d, s most nincs) */
        0.05,                  /* torzitas */
        {{0.5, 0.1, "16' harm."},
         {1, 0.99, "8' (alap)"},
         {2, 0.0, "4' harm."},
         {4, 0.0, "2' harm."},
         {0}},                  /* felharmonikusok lezaro nullaja */
    };
    Szinti sz = {
        &hsz, hangok,          /* hangszin struktura; hangok tomb */
        0.266666666, 0.1,      /* amplmod */
        2048,                  /* master volume */
    };
    ZeneGep zg = { &sz, 0.8 };
    SDL_TimerID id;

    /* user interface dolgai */
    Widget *widgetek[320], *gomb;
    int db, x, y, i, x1, y1;

    /* SDL es a sajat konyvtaraink inicializalasa */
    SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_TIMER);
    widget_init("InfoC Tone Matrix", 700, 480);
    hang_init(&sz);

    /* a felhasznaloi felulet megepitese - a widgetek letrehozasa */
    db = 0;

    /* a matrix */
    x1 = 312;
    y1 = 30;
    for (y = 0; y < 16; ++y)
        widgetek[db++] = uj_felirat(x1, y1 + y * 22 + 6, hangok[y].nev);
    for (x = 0; x < 16; ++x)
        for (y = 0; y < 16; ++y)
            widgetek[db++] = zg.gomb[x][y] =
                uj_villanogomb(x1 + 12 + x * 22, y1 + y * 22, 20, 20, 0);

    /* hang beallitasai */
    x1 = 20;
    y1 = 35;
    widgetek[db++] = uj_felirat(x1 + 0, y1 + 0, "tempo");
    widgetek[db++] = uj_csuszka(x1 + 130, y1 + 0 - 4, 100, 20, &zg.tempo);

    widgetek[db++] = uj_felirat(x1, y1 + 60, "felfutas (s)");
    widgetek[db++] = uj_csuszka(x1 + 130, y1 + 60 - 4, 100, 20, &hsz.felfutas_ido);
    widgetek[db++] = uj_felirat(x1, y1 + 90, "elengedes (s)");
    widgetek[db++] = uj_csuszka(x1 + 130, y1 + 90 - 4, 100, 20, &hsz.elengedes_ido);
    widgetek[db++] = uj_felirat(x1, y1 + 120, "tremolo f (Hz)");
    widgetek[db++] = uj_csuszka(x1 + 130, y1 + 120 - 4, 100, 20, &sz.amplmod_frek);
    widgetek[db++] = uj_felirat(x1, y1 + 150, "tremolo A (%)");
    widgetek[db++] = uj_csuszka(x1 + 130, y1 + 150 - 4, 100, 20, &sz.amplmod_ampl);
    widgetek[db++] = uj_felirat(x1, y1 + 180, "torzitas (%)");
    widgetek[db++] = uj_csuszka(x1 + 130, y1 + 180 - 4, 100, 20, &hsz.torz);

    for (i = 0; hsz.felharm[i].frekszorzo != 0; ++i) {
        widgetek[db++] = uj_felirat(x1, y1 + 240 + i * 30, hsz.felharm[i].nev);
        widgetek[db++] =
            uj_csuszka(x1 + 130, y1 + 240 + i * 30 - 4, 100, 20, &hsz.felharm[i].arany);
    }

    /* also gombok - mentes, betoltes stb. */
    widgetek[db++] = gomb = uj_gomb(60, 440, 100, 20, "ures");
    gomb->felhasznaloi_cb = ures_matrix;
    gomb->felhasznaloi_cb_param = (void *) &zg;
    widgetek[db++] = gomb = uj_gomb(220, 440, 100, 20, "ment");
    gomb->felhasznaloi_cb = mentes;
    gomb->felhasznaloi_cb_param = (void *) &zg;
    widgetek[db++] = gomb = uj_gomb(380, 440, 100, 20, "betolt");
    gomb->felhasznaloi_cb = betoltes;
    gomb->felhasznaloi_cb_param = (void *) &zg;
    widgetek[db++] = gomb = uj_gomb(540, 440, 100, 20, "kilep");
    gomb->felhasznaloi_cb = kilep_gomb_cb;

    widgetek[db] = NULL;        /* lezaro elem */

    /* ez fogja gyartani a usereventeket */
    id = SDL_AddTimer(120, idozit, (void *) &zg);
    /* az esemenyvezerelt foprorgam szamara beregisztraljuk, hogy amikor
     * megjon a userevent, akkor zene_leptet(&zg)-t kell hivni */
    callback_regisztral(ZENET_LEPTET, zene_leptet, &zg);

    /* hang inditasa es belepes az esemenyvezerelt hurokba */
    hang_start();
    esemenyvezerelt_main(widgetek);
    hang_stop();

    SDL_RemoveTimer(id);
    hang_bezar();
    for (i = 0; widgetek[i] != NULL; ++i)
        free(widgetek[i]);

    return 0;
}
